unit Main;


// ================================================================
(*
                  TCP/IP 
              TCP/IP 

   TCP/IP      ,
           .
          
      ,      .
    ,       
         .
   // -----------------------------------------------------
    3.7. ()  , , , 2017..2020 .
               () Source code  ..
     12.01.2020
*)
// ================================================================
//                       TCP-
// ================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CheckLst,  ComCtrls, ExtCtrls,
  // Indy -   
  IdComponent, IdThreadMgr, IdThreadMgrDefault,
  IdBaseComponent, IdTCPServer,
  IdSocketHandle, IdStack, IdGlobal, IdResourceStrings,
  //  
  CommonDEF03, CommonDAT03, CommonSRV03, Dispatch03,
  SensorGroup03,
  // .,   
  AppData00, AppData01, AppData02, AppData03, AppData04, AppData05;

type
  TServerForm = class(TForm)
    TCPServer: TIdTCPServer;
    ThreadMgrDefault: TIdThreadMgrDefault;
    chLboxIPs       : TCheckListBox;
    lstboxAllClients: TListBox;
    Panel1: TPanel;
    edPort: TEdit;
    Button1: TButton;
    cbboxViewPorts: TComboBox;
    StaticText1: TStaticText;
    Button2: TButton;
    edPSW: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Panel2: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    Memo1: TMemo;
    Label7: TLabel;
    CbBoxAppIndx: TComboBox;
    btnOpenSensorGroup: TButton;
    Label8: TLabel;
    stxtMemory: TStaticText;
    Label9: TLabel;
    stxtIndyVer: TStaticText;
    procedure TCPServerDisconnect(AThread: TIdPeerThread);
    procedure TCPServerExecute(AThread: TIdPeerThread);
    procedure TCPServerConnect(AThread: TIdPeerThread);
    procedure cbboxViewPortsChange(Sender: TObject);


    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lstboxAllClientsClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnOpenSensorGroupClick(Sender: TObject);
    procedure CbBoxAppIndxClick(Sender: TObject);
  private
     { Private declarations }
     //       
     function PortDescription(const PortNumber: integer): string;
     //   IP-  
     procedure PopulateIPAddresses();
     //     Socket   .
     function UpdateBindings(RqListIP : TCheckListBox;
                             RqPort   : string) : boolean;
     //     ().
     function GetClientCount() : integer;
     //  Disconnect   
     procedure DisconnectClient(AThread: TIdPeerThread);
     //      
     function RqDisconnectAllClients() : boolean;
     //      
     procedure UpdateClientsList (RqList   : TListBox;
                                  RqReport : TMemo);
     //    .
     function ServerActivate(RqActivate : boolean) : boolean;
  public
     { Public declarations }
  end;

var
  ServerForm: TServerForm;

// ================================================================
// ================================================================
implementation
{$R *.dfm}
// ================================================================
// ================================================================

// ================================================================
//      
// ================================================================
// ------------------------------
//     
const cRepTimeOut = 20;         //      
      cFieldSep   = ':';        //      
      cRepYES     = 'YES';      //     
      cRepNOT     = 'NOT';      //     
      cCmdEND     = 'END';      //    
// -----------------------------
//   
const cCmdConnect    = 'CNN';   //     
      cCmdDisConnect = 'DCN';   //     
      cCmdLink       = 'LNK';   //      
      cCmdService    = 'SRV';   //      

// -----------------------------
//   
const cCmdGET       = 'GET';    //    
      cCmdSET       = 'SET';    //      

// ------------------------------
//    
type TAgent  = class(TObject)
   AThread   : TIdPeerThread;  //  ,   
   IP        : string;         // IP -  
   Port      : integer;        // Port - 
   Name      : string;         //  
   Password  : string;         //  
   ClientMsg : string;         //    
   ServerMsg : string;         //   
end;

// ================================================================
//  12.01.2020
//     () .
var CurrAppIndx    : integer;
// ================================================================

// ================================================================
//   
// ================================================================
// ----------------------------------------------------------------
// 24.11.2016
//      
//  1
//   Cmd = 'field1:field2:field3'
//   Result = 'field1', Cmd = 'field2:field3'
//  2
//   Cmd = 'field3'
//   Result = 'field3', Cmd = ''
function CutNextCmdField(var Cmd : string) : string;
var wPos : integer;
    wStr : string;
begin
   wStr   := Trim(Cmd);
   Result := wStr;
   wPos   := pos(cFieldSep, wStr);
   if wPos > 0
   then begin
        Result := copy(wStr, 1, wPos - 1);
        if (Length(wStr) > wPos)
        then Cmd := copy(wStr, wPos + 1, Length(wStr))
   end
   else Cmd := '';
end;
// ----------------------------------------------------------------
//  12.01.2020
//      
// (Berkeley standard) .  : IdStack
function TServerForm.PortDescription(const PortNumber: integer): string;
var ST  : TStrings;
begin
  //  ,    ( IANA) ,
  //    windows\system32\drivers\etc\services
  ST := GStack.WSGetServByPort(PortNumber);
  //   TCP -    
  with ST do
  try
    Result := '';
    if Count > 0
    then begin
      Result := IntToStr(PortNumber) + ': ' + Strings[0];
    end;
  finally
    Free;
  end;
end;
// ----------------------------------------------------------------
//  12.01.2020
//   IP-    chboxIPs,
//     cbboxViewPorts   
//      .
//  : IdGlobal, IdStack, IdResourceStrings
procedure TServerForm.PopulateIPAddresses();
const DefaultPort = '9099';
var Ind : integer;
begin
  with chLboxIPs do
    begin
    //   IP-  
    Clear;
    Items := GStack.LocalAddresses;  // IP-   (TStrings)
    Items.Insert(0, '127.0.0.1');    //   IP-
    end;
    //     
    cbboxViewPorts.Items.BeginUpdate;
    cbboxViewPorts.Items.Add(DefaultPort + ': Default port');
    try
       // cbboxViewPorts.Items.Add(RSBindingAny);
       for Ind := 0 to IdPorts.Count - 1 do
           //    TCP 
           cbboxViewPorts.Items.Add(PortDescription(Integer(IdPorts[Ind])));
    finally
       cbboxViewPorts.Items.EndUpdate;
    end;
    //     
    cbboxViewPorts.ItemIndex := 0;
    edPort.Text := DefaultPort;
end;

// ----------------------------------------------------------------
//  12.01.2020
//     edtPort
procedure TServerForm.cbboxViewPortsChange(Sender: TObject);
    //     
    function GetPort(AString : String) : String;
    begin
       Result := AString;
       if pos(':', AString) > 0
       then Result := copy(AString, 1, pos(':', AString) - 1);
    end;
begin
 edPort.Text := GetPort(cbboxViewPorts.Items.Strings[cbboxViewPorts.ItemIndex]);
end;

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
//     Socket   .
function TServerForm.UpdateBindings(RqListIP : TCheckListBox;
                                    RqPort   : string) : boolean;
var
  Binding   : TIdSocketHandle;   //    
  Port      : integer;           //    
  BindCount : integer;           //   
  Ind       : integer;
begin
  Result := False;
  //    
  //   bindings     
  if TCPServer.Active then Exit;
  //    
  Port := -1;
  try
    Port := StrToInt(Trim(RqPort));
  except
    MessageDlg('     ',
                mtError, [mbOk], 0);
  end;
  if Port < 0  then Exit;
  //  bindings
  if not RqListIP.Count > 0 then Exit;
  BindCount := 0;
  try
     //  bindings
     TCPServer.Bindings.Clear;
     for Ind := 0 to RqListIP.Count-1 do
     if RqListIP.Checked[Ind]
     then  begin
        //   
        Binding := TCPServer.Bindings.Add;
        Binding.IP := RqListIP.Items.Strings[Ind];
        Binding.Port := Port;
        Inc(BindCount);
     end;
     if BindCount > 0
     then Result := True
     else MessageDlg('  IP   .',
                      mtError, [mbOk], 0);;
  except
     MessageDlg('     .',
     mtError, [mbOk], 0);
  end;
end;
// ----------------------------------------------------------------
//  12.01.2020
//     ().
function TServerForm.GetClientCount() : integer;
var List : TList;
begin
   Result := - 1;
   try
     //       
     List := TCPServer.Threads.LockList;
     if Assigned(List) then Result := List.Count;
   finally
    //  
    TCPServer.Threads.UnlockList;
  end;
end;


// ----------------------------------------------------------------
//  12.01.2020
//    .
function TServerForm.ServerActivate(RqActivate : boolean) : boolean;
var Deactivate : boolean;
begin
   Result := True;
   if RqActivate
   then begin
       //  
       if TCPServer.Active then Exit;
       //      .
       if not UpdateBindings(chLboxIPs, edPort.Text) then Exit;
       //  
       try
          TCPServer.Active := True;
       except
          Result := False;
          MessageDlg('  .',
          mtError, [mbOk], 0);
       end;
   end
   else begin
       //  
       if not TCPServer.Active then Exit;
       //    
       Deactivate := True;
       if GetClientCount() > 0
       then Deactivate := RqDisconnectAllClients();
       //  
       if Deactivate
       then begin
          try
            TCPServer.Active := False;
          except
            Result := False;
            MessageDlg('   .',
                       mtError, [mbOk], 0);
          end;
       end;
   end;
end;

// ----------------------------------------------------------------
//  12.01.2020
//     
procedure TServerForm.UpdateClientsList (RqList   : TListBox;
                                         RqReport : TMemo);
var wList   : TList;
    AThread : TIdPeerThread;
    wAgent  : TAgent;
    Ind     : integer;
begin
  RqList.Clear;
  RqReport.Clear;
  try
     //        
     wList := TCPServer.Threads.LockList;
     if Assigned(wList)
     then begin
        for Ind := 0 to wList.Count -1
        do begin
           AThread  := TIdPeerThread(wList.Items[Ind]);
           wAgent   := TAgent(AThread.Data);
           if Assigned(wAgent)
           then RqList.Items.AddObject(wAgent.Name
                                       + '  IP:'
                                       + wAgent.IP,
                                       wAgent);
        end;
     end;
  finally
    //  
    TCPServer.Threads.UnlockList;
  end;
end;

// ----------------------------------------------------------------
//  12.01.2020
procedure TServerForm.TCPServerConnect(AThread: TIdPeerThread);
var wAgent : TAgent;
    wMsg   : string;
    wCmd   : string;
    wName  : string;
    wPSW   : string;
begin
   wMsg  := '';
   wMsg  := AThread.Connection.ReadLn('',cRepTimeOut);
   wCmd  := CutNextCmdField(wMsg);
   wName := CutNextCmdField(wMsg);
   wPSW  := CutNextCmdField(wMsg);
   if (wCmd <> cCmdConnect) or (wName = '') or (wPSW  = '')
   then begin
      //    
      AThread.Connection.WriteLn(cRepNOT + cFieldSep
                               + '  ');
      Exit;
   end;
   if wPSW = edPSW.Text   //    
   then begin
       //      
       wAgent := TAgent.Create;
       //       
       AThread.Data  := wAgent;
       wAgent.AThread := AThread;
       //     ( IP  Port  )
       wAgent.IP   := AThread.Connection.Socket.Binding.PeerIP;
       wAgent.Port := AThread.Connection.Socket.Binding.PeerPort;
       wAgent.Name      := wName;
       wAgent.Password  := wPSW;
       wAgent.ClientMsg := '    ' + wName;
       //      
       wAgent.ServerMsg := cRepYES + cFieldSep
                        + '   ';
       AThread.Connection.WriteLn(wAgent.ServerMsg);
       //     
       UpdateClientsList(lstboxAllClients, Memo1);
   end
   else begin
       //    
       AThread.Connection.WriteLn(cRepNOT + cFieldSep
                                + ' ');
       AThread.Connection.Disconnect;
   end;
end;
// ----------------------------------------------------------------
//  12.01.2020
//  Disconnect   
procedure TServerForm.DisconnectClient(AThread: TIdPeerThread);
var Agent  : TAgent;
begin
   if not Assigned(AThread) then Exit;
   Agent := TAgent(AThread.Data);
   if Assigned(Agent)
   then begin
      AThread.Data := nil;
      Agent.Free;
   end;
   AThread.Connection.WriteLn(cCmdEND);
   AThread.Connection.Disconnect;
end;
// ----------------------------------------------------------------
//  12.01.2020
//      
function TServerForm.RqDisconnectAllClients() : boolean;
var List    : TList;
    AThread : TIdPeerThread;
    Ind     : integer;
begin
  Result := False;
  if MessageDlg('    .'
                + #13#10 + '   ?',
              mtConfirmation, [mbYes, mbNo], 0) = mrYes
  then begin
     try
        //       
        List := TCPServer.Threads.LockList;
        if Assigned(List)
        then begin
           for Ind := 0 to List.Count -1
           do begin
             AThread := TIdPeerThread(List.Items[Ind]);
             DisconnectClient(AThread);
           end;
        end;
     finally
        //  
        TCPServer.Threads.UnlockList;
     end;
     //     
     UpdateClientsList(lstboxAllClients, Memo1);
     Result := True;
  end;
end;
// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
//   "    "
procedure TServerForm.TCPServerExecute(AThread: TIdPeerThread);
var wAgent   : TAgent;
    wMsgSRC  : string;
    wMsg     : string;
    wSysCmd  : string;
    wUserCmd : string;
    wUCmdPrm : string;
    wRep     : string;
    wRequest : TRequest; //     
begin
   //    
   wAgent := TAgent(AThread.Data);
   //      
   wMsgSRC := AThread.Connection.ReadLn;
   wMsg := wMsgSRC;
   //      
   wSysCmd  := CutNextCmdField(wMsg);
   //      
   if wSysCmd  <> cCmdLink
   then if Assigned(wAgent)then wAgent.ClientMsg := ' : ' + wMsgSRC;
   // ---------------------------
   //      
   if wSysCmd = cCmdLink
   then begin
      //    
      wRep := cRepYES + cFieldSep + '  ';
      AThread.Connection.WriteLn(wRep);
      Exit;
   end;
   // ---------------------------
   //     
   if wSysCmd  = cCmdDisConnect
   then begin
      //    
      wRep := cRepYES + cFieldSep + '    ';
      AThread.Connection.WriteLn(wRep);
      //   
      DisconnectClient(AThread);
      //     
      UpdateClientsList(lstboxAllClients, Memo1);
      Exit;
   end;
   // ---------------------------
   // ===========================
   //      
   if wSysCmd = cCmdService
   then begin
      //      
      wUserCmd  := CutNextCmdField(wMsg);
      //      
      wUCmdPrm  := CutNextCmdField(wMsg);
      //     
      wRequest.RqCmd := wUCmdPrm;
      // ---------------------------
      //    
      //   wRequest,  
      //   wRequest.
      // ---------------------------
      if ServiceDispatch(wRequest)
      then begin
          // ---------------------------
          //    
          wRep := cRepYES;
          AThread.Connection.WriteLn(wRep);
          // ---------------------------
          //       ( cCmdGET )
          if wUserCmd = cCmdGET
          then begin
             //    
             AThread.Connection.WriteBuffer(wRequest.Buffer^,
                                            wRequest.BufSize,
                                            True);
           // ---------------------------
          end;
      end
      else begin
          //    
          wRep := cRepNOT;
          AThread.Connection.WriteLn(wRep);
      end;
      //      
      if Assigned(wAgent)then wAgent.ServerMsg := ' : ' + wRep;
   end;
   // ===========================
end;
// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
//   -  
procedure TServerForm.TCPServerDisconnect(AThread: TIdPeerThread);
begin
  //     
  UpdateClientsList(lstboxAllClients, Memo1);
end;

// ================================================================
//  / 
// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
procedure TServerForm.FormCreate(Sender: TObject);
var Ind : integer;
begin
   //  Indy
   stxtIndyVer.Caption := ' ' + gsIdProductName + ' Ver : ' + gsIdVersion;
   //  IP   
   PopulateIPAddresses();
   //         
   LoadAllScopeAndSensorArr();
   //   
   CurrAppIndx := -1;
   //    .
   CbBoxAppIndx.Clear;
   for Ind := Low(AllSensorArr) to High(AllSensorArr)
   do CbBoxAppIndx.Items.Add(AllSensorArr[Ind].AppName);
   if CbBoxAppIndx.Items.Count > 0
   then CbBoxAppIndx.ItemIndex := 0;
end;

// ================================================================
//  
// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
//  
procedure TServerForm.Button1Click(Sender: TObject);
begin
  ServerActivate(True);
  if TCPServer.Active then StaticText1.Color := clLime;
end;
// ----------------------------------------------------------------
//  12.01.2020
//  
procedure TServerForm.Button2Click(Sender: TObject);
begin
  ServerActivate(False);
  if not TCPServer.Active then StaticText1.Color := clBtnFace;
end;
// ----------------------------------------------------------------
//  12.01.2020
//     
procedure TServerForm.lstboxAllClientsClick(Sender: TObject);
var Ind     : integer;
    wAgent  : TAgent;
begin
    Ind := lstboxAllClients.ItemIndex;
    wAgent := TAgent(lstboxAllClients.Items.Objects[Ind]);
    Memo1.Clear;
    if Assigned(wAgent)
    then begin
       Memo1.Lines.Add(wAgent.ClientMsg);
       Memo1.Lines.Add(wAgent.ServerMsg);
    end;
end;
// ----------------------------------------------------------------
//  12.01.2020
//       
procedure TServerForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if (GetClientCount() > 0) or (TCPServer.Active)
  then begin
    Action := caNone;
    MessageDlg('    '
    + #13#10 + '    '
    + #13#10 + '  ( Online )...',
               mtInformation, [mbOk], 0);
  end;
end;
// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
//       .
procedure TServerForm.CbBoxAppIndxClick(Sender: TObject);
begin
  SensorGroupForm.Close;
end;
// ----------------------------------------------------------------
//  12.01.2020
//        
procedure TServerForm.btnOpenSensorGroupClick(Sender: TObject);
begin
   if CurrAppIndx <> CbBoxAppIndx.ItemIndex
   then begin
       CurrAppIndx := -1;
       CurrAppIndx := SensorGroupForm.OpenSensors(CbBoxAppIndx.ItemIndex);
   end;
   stxtMemory.Caption := IntToStr(AllocMemSize);
   SensorGroupForm.Show;
end;

// ================================================================
// 
// ================================================================


end.
